function sl_customization(cm)

% Disable for standalone Configuration Parameters dialog box.
cm.addDlgPreOpenFcn('Simulink.ConfigSet',@disableSolverButton)

% Disable for Configuration Parameters dialog box that appears in
% the Model Explorer.
cm.addDlgPreOpenFcn('Simulink.SolverCC',@disableSolverButton)

end

function disableSolverButton(dialogH)

% Disable the SolverType dialog box
dialogH.disableWidgets({'Simulink.SolverCC.SolverType'})

% Disable the Solver dialog box
dialogH.disableWidgets({'Simulink.SolverCC.Solver'}) 

% Hide the Start Time dialog box
dialogH.hideWidgets({'Simulink.SolverCC.StartTime'})

end