function sl_customization(cm)
%% Register custom menu function.
  cm.addCustomMenuFcn('Simulink:ToolsMenu', @getMyMenuItems);
end

%% Define the custom menu function.
 function schemaFcns = getMyMenuItems
  schemaFcns = {@getItem1,...
						@getItem2,...
						{@getItem3,3}... %% Pass 3 as user data to getItem3.
						@getItem4}; 
 end

 %% Define the schema function for the menu items.
 
 function schema = getItem1(callbackInfo)
  schema = sl_action_schema;
  schema.label = 'Item One';
  schema.userdata = 'one';	
  schema.callback = @myCallback1; 
 end
 
 function myCallback1(callbackInfo)
  disp(['Callback for item ' callbackInfo.userdata ' was called']);
 end

function schema = getItem2(callbackInfo)
  % Make a submenu label 'Item Two' with     
  % the menu item above three times.      
  schema = sl_container_schema;
  schema.label = 'Item Two';    
  schema.userdata = 'two';	
  schema.childrenFcns = {@getItem1, @getItem1, @getItem1};
end 

function schema = getItem3(callbackInfo)
  % Create a menu item whose label is
  % 'Item Three: 3', with the 3 being passed
  % from getMyItems above.
  schema = sl_action_schema;
  schema.label = 'Item Three';  
  schema.userdata = 'three';
  schema.callback = @myCallback3; 
end

function myCallback3(callbackInfo)
  disp(['Callback for item ' callbackInfo.userdata ' was called']);
end

function myToggleCallback(callbackInfo)
    if strcmp(get_param(gcs, 'ScreenColor'), 'red') == 0
        set_param(gcs, 'ScreenColor', 'red');
    else
        set_param(gcs, 'ScreenColor', 'white');
    end
end

%% Define the schema function for a toggle menu item.
function schema = getItem4(callbackInfo)
  schema = sl_toggle_schema;
  schema.label = 'Red Screen';
  if strcmp(get_param(gcs, 'ScreenColor'), 'red') == 1
    schema.checked = 'checked';
  else
    schema.checked = 'unchecked';
  end
  schema.callback = @myToggleCallback; 
end
