function [Y,Xf,Af] = neural_function(X,~,~)
%NEURAL_FUNCTION neural network simulation function.
%
% Auto-generated by MATLAB, 29-Aug-2019 16:14:24.
% 
% [Y] = neural_function(X,~,~) takes these arguments:
% 
%   X = 1xTS cell, 1 inputs over TS timesteps
%   Each X{1,ts} = 2xQ matrix, input #1 at timestep ts.
% 
% and returns:
%   Y = 1xTS cell of 1 outputs over TS timesteps.
%   Each Y{1,ts} = 1xQ matrix, output #1 at timestep ts.
% 
% where Q is number of samples (or series) and TS is the number of timesteps.

%#ok<*RPMT0>

% ===== NEURAL NETWORK CONSTANTS =====

% Input 1
x1_step1.xoffset = [0.0591313085340746;0.0779557075787304];
x1_step1.gain = [99.9515891187524;69.6187452268672];
x1_step1.ymin = -1;

% Layer 1
b1 = [-6.049885351345483997;-4.8819047314201977628;-4.8366764569310500832;-4.6217214914186097729;-3.5487483756948914326;2.9987182046720097794;2.2077873882473997291;1.6678313274422940093;0.42888130152224224201;0.17096829876026220507;-0.42595945173295063357;-1.3056318666450432708;1.9083387868825036904;2.3164808154671439056;2.5406138600608305644;3.5135841136432404141;4.135291316915330917;-4.9454623439106111249;-5.1889792815287991701;6.5394242214420694737];
IW1_1 = [2.0157046825164490755 -6.0818257041552801212;5.7928315767703200123 3.7663954047763699151;6.7466776464171598349 0.93936315102320433468;0.29630363639141155119 5.8798544076487946342;6.0824443441708480051 0.25944522207425796401;-5.8095159015477255693 -2.2296275240164775688;-6.0700353724134732403 2.373647260713079632;-5.3957734524789415786 3.0730642354706709796;-6.3081145485692706742 0.19801229527278460529;-3.257103668772237004 -5.2639901776072601791;-0.99723347129657269328 -6.2308109935003805901;-5.2489965539787579729 3.0093004829421565738;4.6241173607677934498 -4.141605308499864968;1.535900151153511306 -6.1525568131313432829;4.5979493722410476053 4.4895831081673964746;5.4654408063434001264 -3.1357780357889013523;6.2960232127211677167 -0.75795597732280517445;-5.3433624363752869613 3.2612182986801139251;-6.1605028385541151792 -2.7259833983828332116;3.5532927448809319415 4.4965033336775830364];

% Layer 2
b2 = 0.42076548548095588087;
LW2_1 = [0.56389017722047374281 0.48726833733195262788 0.46768067792798495574 -0.19122277763374664894 -1.0660210559502243388 -0.0078712698881203673612 -0.37206478977385304407 0.29003406334745734929 0.0038014152258846328758 0.00086625121541756069932 0.069967988170102246581 -0.18849290820310460326 -0.13001082124622004299 0.31415455863365510103 -0.13780996635381637105 0.33092675462363085881 0.14644242099642876265 0.22228592147751297103 0.27365632016096413937 -0.29427440711010394159];

% Output 1
y1_step1.ymin = -1;
y1_step1.gain = 2.50390479791496;
y1_step1.xoffset = 1.15879749479161;

% ===== SIMULATION ========

% Format Input Arguments
isCellX = iscell(X);
if ~isCellX
  X = {X};
end

% Dimensions
TS = size(X,2); % timesteps
if ~isempty(X)
  Q = size(X{1},2); % samples/series
else
  Q = 0;
end

% Allocate Outputs
Y = cell(1,TS);

% Time loop
for ts=1:TS

    % Input 1
    Xp1 = mapminmax_apply(X{1,ts},x1_step1);
    
    % Layer 1
    a1 = tansig_apply(repmat(b1,1,Q) + IW1_1*Xp1);
    
    % Layer 2
    a2 = repmat(b2,1,Q) + LW2_1*a1;
    
    % Output 1
    Y{1,ts} = mapminmax_reverse(a2,y1_step1);
end

% Final Delay States
Xf = cell(1,0);
Af = cell(2,0);

% Format Output Arguments
if ~isCellX
  Y = cell2mat(Y);
end
end

% ===== MODULE FUNCTIONS ========

% Map Minimum and Maximum Input Processing Function
function y = mapminmax_apply(x,settings)
  y = bsxfun(@minus,x,settings.xoffset);
  y = bsxfun(@times,y,settings.gain);
  y = bsxfun(@plus,y,settings.ymin);
end

% Sigmoid Symmetric Transfer Function
function a = tansig_apply(n,~)
  a = 2 ./ (1 + exp(-2*n)) - 1;
end

% Map Minimum and Maximum Output Reverse-Processing Function
function x = mapminmax_reverse(y,settings)
  x = bsxfun(@minus,y,settings.ymin);
  x = bsxfun(@rdivide,x,settings.gain);
  x = bsxfun(@plus,x,settings.xoffset);
end
